package gov.va.med.mhv.integration.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * User: Rob Murtha
 * Date: Jan 8, 2008
 * 
 */
public class DateUtil {
    static final String CREATION_DATE_FORMAT_STRING = "yyyyMMddHHmmss";
    static final String BASIC_DATE_FORMAT_STRING = "yyyyMMdd.HHmmss";
    static final String QUERY_DATE_FORMAT_STRING = "yyyyMMdd";
    static final String DATETIME_FORMAT_STRING = "dd MMM yyyy @ HHmm";
    static final String DATEONLY_FORMAT_STRING = "dd MMM yyyy";
    static final String DATE_FORMAT_STRING = "MMM dd, yyyy";
    static final String CVIXDATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ssX";

    private static ThreadLocal cdf = new ThreadLocal() {
          protected synchronized Object initialValue() {
              return new SimpleDateFormat(CREATION_DATE_FORMAT_STRING);
          }
      };

    private static ThreadLocal sdf = new ThreadLocal() {
          protected synchronized Object initialValue() {
              return new SimpleDateFormat(BASIC_DATE_FORMAT_STRING);
          }
      };

    private static ThreadLocal qdf = new ThreadLocal() {
          protected synchronized Object initialValue() {
              return new SimpleDateFormat(QUERY_DATE_FORMAT_STRING);
          }
      };
      
    private static ThreadLocal dtf = new ThreadLocal() {
          protected synchronized Object initialValue() {
              return new SimpleDateFormat(DATETIME_FORMAT_STRING);
          }
      };
      
    private static ThreadLocal df = new ThreadLocal() {
          protected synchronized Object initialValue() {
              return new SimpleDateFormat(DATEONLY_FORMAT_STRING);
          }
      };  
    
      private static ThreadLocal d = new ThreadLocal() {
          protected synchronized Object initialValue() {
              return new SimpleDateFormat(DATE_FORMAT_STRING);
          }
      };  

      private static ThreadLocal cvdf = new ThreadLocal() {
          protected synchronized Object initialValue() {
              return new SimpleDateFormat(CVIXDATE_FORMAT_STRING);
          }
      };  

    private static SimpleDateFormat getCreationDateFormat() {
        return (SimpleDateFormat)cdf.get();
    }

    private static SimpleDateFormat getBasicDateFormat() {
        return (SimpleDateFormat)sdf.get();
    }

    private static SimpleDateFormat getQueryDateFormat() {
        return (SimpleDateFormat)qdf.get();
    }
    
    private static SimpleDateFormat getDateTimeFormat() {
        return (SimpleDateFormat)dtf.get();
    }

    private static SimpleDateFormat getDateOnlyFormat() {
        return (SimpleDateFormat)df.get();
    }
    
    private static SimpleDateFormat getDateFormat() {
        return (SimpleDateFormat)d.get();
    }
    
    private static SimpleDateFormat getCvixDateFormat() {
        return (SimpleDateFormat)cvdf.get();
    }

    public static String transformDateOnly(Date date) {
        return DateUtil.getDateOnlyFormat().format(date);
    }

    public static String transformDateTime(Date date) {
        return DateUtil.getDateTimeFormat().format(date);
    }

    public static Date parseVistaDate(String dateString) throws ParseException {
        return DateUtil.getBasicDateFormat().parse(dateString);
    }
    
    public static Date transformDate(String dateString) throws ParseException {
        return DateUtil.getDateFormat().parse(dateString);
    }
    
    public static Date parseCvixDate(String dateString) throws ParseException {
   	 return DateUtil.getCvixDateFormat().parse(dateString);
   }

    /**
     * Utility for converting string into a valid date.
     *
     * @param dateString in the format of yyyyMMdd.kkmmss - nulls accepted
     * @return a valid date or null
     */
    public static Date parseVistaDateOrNull(String dateString) throws NumberFormatException {
        try {
            if (dateString != null)
                return DateUtil.getBasicDateFormat().parse(dateString);
        } catch (ParseException ignore) {
        }
        return null;
    }

	public static Date parseCdsDate(String dateString) throws ParseException {
        return DateUtil.getBasicDateFormat().parse(dateString);
    }
	
	public static Date parsePathwaysDate(String dateString) throws ParseException {
		if(dateString != null && dateString.length() < DateUtil.getCreationDateString().length())
		{
			dateString = DateUtil.padDateString(dateString, '0', DateUtil.getCreationDateString().length());
		}
        return DateUtil.getCreationDateFormat().parse(dateString);
    }

    public static String transformQueryDate(Date date) {
        return DateUtil.getQueryDateFormat().format(date);
    }
    
    public static String transformBasicDate(Date date) {
        return DateUtil.getBasicDateFormat().format(date);
    }

    public static synchronized String getYesterdayString() {
        Calendar cal=Calendar.getInstance();
        cal.add(Calendar.DAY_OF_MONTH,-1);
        return(DateUtil.getQueryDateFormat().format(cal.getTime()));
    }

    public static synchronized String getTodayString() {
        Calendar cal=Calendar.getInstance();
        return(DateUtil.getQueryDateFormat().format(cal.getTime()));
    }

    public static Date getYesterdayDate() {
        try {
            return DateUtil.getQueryDateFormat().parse(getYesterdayString());
        } catch (ParseException ignore) {
        }
        return null;
    }

    public static Date getTodayDate() {
        try {
            return DateUtil.getQueryDateFormat().parse(getTodayString());
        } catch (ParseException ignore) {
        }
        return null;
    }

    public static Date createDate(String dateString)  {
        try {
            return DateUtil.getQueryDateFormat().parse(dateString);
        } catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public static Timestamp dateToTimestamp(Date theDate) {
        return theDate == null ? null : new Timestamp(theDate.getTime());
    }

    public static String getCreationDateString() {
        Calendar cal=Calendar.getInstance();
        return(DateUtil.getCreationDateFormat().format(cal.getTime()));
    }
    
    public static synchronized Date getDateDaysAgo(int daysAgo) {
    	Calendar cal=Calendar.getInstance();
        cal.add(Calendar.DATE,(-1*daysAgo));
        return(cal.getTime());
    }
    
    public static String padDateString( String dateString, char padChar, int length)
    {
    	StringBuffer sbDateStr = new StringBuffer(dateString);
    	
    	for(int i = sbDateStr.length(); i < length; i++)
    	{
    		sbDateStr.append(padChar);
    	}
    	
    	return sbDateStr.toString();
    }
    
	public static Date addDays(Date date, int days)
	{
	    Calendar c = Calendar.getInstance();
	    c.setTime(date);
	    c.add(Calendar.DATE, days);
	    date.setTime( c.getTime().getTime() );
	    
	    return date;
	}
    
    public static void main(String v[]) {
    	try {
			DateUtil.parseCvixDate("2005-05-02T00:01:00-04:00");
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	
    	System.out.println("Date -3 days : " + DateUtil.addDays(new Date(), -3));
    }
}
